classdef preparser < userdataobj
% preparser  [Not a public class] IRIS preparser. 
%
% Backend IRIS class.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

    properties
        assign = struct();
        fname = '';
        code = '';
        labels = {};
        Export = {};
        subs = struct();
    end
        
    methods
        
        function this = preparser(varargin)
            % preparser  General IRIS code preparser.
            % p = preparser(inputFile)
            % p = preparser(inputFile,assign)
            % p = preparser(inputFile,assign,savesas)
            % p = preparser(inputFile,assign,savesas,labels)
            if nargin == 0
                return
            end
            if isa(varargin{1},'preparser')
                this = varargin{1};
                return
            end
            inputfiles = varargin{1};
            varargin(1) = [];
            if ischar(inputfiles)
                inputfiles = {inputfiles};
            end
            this.fname = inputfiles{1};
            for i = 2 : length(inputfiles)
                this.fname = [this.fname,' & ',inputfiles{2}];
            end
            % Parse options.
            [opt,varargin] = passvalopt('preparser.preparser',varargin{:});
            % Add remaining input arguments to the assign struct.
            if ~isempty(varargin) && iscellstr(varargin(1:2:end))
                for i = 1 : 2 : length(varargin)
                    opt.assign.(varargin{i}) = varargin{i+1};
                end
            end
            this.assign = opt.assign;
            % Read the code files and resolve preparser commands.
            [this.code,this.labels,this.Export, ...
                this.subs,this.Comment] = ...
                preparser.myreadcode(inputfiles, ...
                opt.assign,{},{},'',opt.removecomments);
            % Save the pre-parsed file if requested by the user.
            if ~isempty(opt.saveas)
                saveas(this,opt.saveas);
            end
        end
        
        function disp(this)
            fprintf('\tpreparser object <a href="matlab:edit %s">%s</a>\n', ...
                this.fname,this.fname);
            disp@userdataobj(this);
            disp(' ');
        end
        
        varargout = saveas(varargin)
        
    end
    
    methods (Hidden)
        varargout = labelsback(varargin)
        % TODO: Create reportingobj and make the parser its method.
        varargout = reporting(varargin)
    end
    
    methods (Static,Hidden)
        varargout = myparsecontrols(varargin)
        varargout = mypseudofunc(varargin)
        varargout = myreadcode(varargin)
        varargout = mysubstitute(varargin)
        varargout = export(varargin)
    end
    
end