function varargout = eval(this,varargin)
% eval  Evaluate posterior density at specified points.
%
% Syntax
% =======
%
%     X = eval(POS)
%     X = eval(POS,P)
%
% Input arguments
% ================
%
% * `POS` [ poster ] - Posterior object returned by the
% [`model/estimate`](model/estimate) function.
%
% * `P` [ numeric | cell ] - Parameter vector or a cell array of parameter
% vectors at which the posterior density will be evaluated; if `P` is not
% specified, the posterior density at the point of the estimated mode is
% returned.
%
% Output arguments
% =================
%
% * `X` [ numeric ] - The value of posterior density evaluated at `P`; if
% `P` is a cell array the numeric array `X` is the same size.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if length(varargin) == 1
    p = varargin{1};
else
    p = varargin;
end

%**************************************************************************

if nargin == 1
    % Evaluate log posterior at optimum.
    varargout{1} = this.initLogPost;
    varargout{2} = [];
else
    % Evaluate log poeterior at specified parameter sets. If
    % it's multiple parameter sets, pass them in as a cell, not
    % as multiple input arguments.
    if isstruct(p)
        s = p;
        npar = length(this.paramList);
        p = nan(1,npar);
        for i = 1 : npar
            p(i) = s.(this.paramList{i});
        end
    end
    [varargout{1:2}] = simulate(this,'eval',p);
end

end

