function varargout = get(this,varargin)
% get  Query plan object properties.
%
% Syntax
% =======
%
%     ANS = get(P,QUERY)
%     [ANS,ANS,...] = get(P,QUERY,QUERY,...)
%
% Input arguments
% ================
%
% * `P` [ plan ] - Simulation plan object.
%
% * `QUERY` [ char ] - Name of the queried property.
%
% Output arguments
% =================
%
% * `ANS` [ ... ] - Answer.
%
% Valid queries on plan objects
% ==============================
%
% * `'endogenised='` - Returns [ struct ] a database with time series for
% each shock with 1 in each period where the variable is endogenised,
% and 0 in each period where the variable is not endogenised.
%
% * `'exogenised='` - Returns [ struct ] a database with time series for
% each measurement and transition variable with 1 in each period where the
% variable is exogenised, and 0 in each period where the variable is not
% exogenised.
%
% * `'onlyEndogenised='` - Returns [ struct ] the same database as
% `'endogenised'` but including only those shocks that are endogenised at
% least in one period.
%
% * `'onlyExogenised='` - Returns [ struct ] the same database as
% `'exogenised'` but including only those measurement and transition
% variables that are endogenised at least in one period.
%
% * `'range='` - Returns [ numeric ] the simulation plan range.
%
% Description
% ============
%
% Example
% ========

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[varargout{1:nargout}] = utils.get(this,varargin{:});

end