function this = condition(this,list,dates)
% condition  Condition forecast upon the specified variables at the specified dates.
%
% Syntax
% =======
%
%     P = condition(M,LIST,DATES)
%
% Input arguments
% ================
%
% * `P` [ plan ] - Simulation plan.
%
% * `LIST` [ cellstr | char ] - List of variables upon which a forecast
% will be conditioned.
%
% * `DATES` [ numeric ] - Dates at which the forecast will be conditioned
% upon the specified variables.
%
% Output arguments
% =================
%
% * `P` [ plan ] - Simulation plan with new conditioning information
% included.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

% Parse required input arguments.
P = inputParser();
P.addRequired('p',@isplan);
P.addRequired('list',@(x) ischar(x) || iscellstr(x));
P.addRequired('dates',@isnumeric);
P.parse(this,list,dates);

% Convert char list to cell of str.
if ischar(list)
    list = regexp(list,'[A-Za-z]\w*','match');
end

if isempty(list)
    return
end

%**************************************************************************

[dates,outofrange] = mydateindex(this,dates);
if ~isempty(outofrange)
    % Report invalid dates.
    utils.error('plan', ...
        'Dates out of simulation plan range: %s.', ...
        dat2charlist(outofrange));
end

nlist = numel(list);
valid = true(1,nlist);

for i = 1 : nlist
    index = strcmp(this.clist,list{i});
    if any(index)
        this.canchors(index,dates) = true;
    else
        valid(i) = false;
    end
end

% Report invalid names.
if any(~valid)
    utils.error('plan', ...
        'Cannot condition upon this name: ''%s''.', ...
        list{~valid});
end

end