function X = mytrendarray(m,id,tvec,delog,alt)
% MYTRENDARRAY  [Not a public function] Create array with steady state paths for all variables.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if nargin < 5
    alt = inf;
end

%**************************************************************************

if islogical(alt)
    alt = find(alt);
elseif isnumeric(alt) && any(isinf(alt))
    alt = 1 : size(m.Assign,3);
end
nalt = length(alt);

nper = length(tvec);
nid = length(id);
X = zeros(nid,nper,nalt);
if nid == 0
    return
end

realid = real(id);
imagid = imag(id);

assign = m.Assign(1,:,alt);
logindex = m.log(realid);
repeat = ones(1,nper);
shift = imagid(:);
shift = shift(:,repeat);
shift = shift + tvec(ones(1,nid),:);

for i = 1 : length(alt)
    level = real(assign(1,realid,i));
    growth = imag(assign(1,realid,i));
    
    % No imaginary part means
    % zero growth for log variables.
    growth(logindex & growth == 0) = 1;
    
    % Use `reallog` to make sure negative numbers throw an error.
    level(logindex) = reallog(level(logindex));
    growth(logindex) = reallog(growth(logindex));
    
    level = transpose(level);
    growth = transpose(growth);
    x = level(:,repeat) + shift.*growth(:,repeat);
    if delog
        x(logindex,:) = exp(x(logindex,:));
    end
    X(:,:,i) = x;
end

end
