function THIS = mysymbdiff(THIS)
% MYSYMBDIFF  [Not a public function] Evaluate symbolic derivatives for model equations.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% Symbolic derivatives of
% * full measurement and transition equations wrt variables;
% * full dtrend equations wrt parameters.
% No derivatives computed for dynamic links.
neqtn = length(THIS.eqtn);
THIS.deqtnF = cell(1,neqtn);
THIS.ceqtnF = cell(1,neqtn);
tzero = THIS.tzero;

userdifflist = '{';
for i = 1 : length(THIS.userdifflist)
    if i > 1
        userdifflist = [userdifflist,',']; %#ok<AGROW>
    end
    userdifflist = [userdifflist,'''',THIS.userdifflist{i},'''']; %#ok<AGROW>
end
userdifflist = [userdifflist,'}'];

for ieq = find(THIS.eqtntype <= 3)
    
    if THIS.eqtntype(ieq) <= 2
        % Measurement or transition equations.
        % Differentiate equations w.r.t. variables and shocks.
        [tmocc,nmocc] = myfindoccur(THIS,ieq,'variables_shocks');
        tmocc = tmocc - tzero;
        mode = 1;
    elseif THIS.eqtntype(ieq) == 3
        % Deterministic trends.
        % Differentiate dtrends w.r.t. parameters.
        [tmocc,nmocc] = myfindoccur(THIS,ieq,'parameters');
        tmocc(:) = 0;
        mode = Inf;
    end
    
    % Differentiate one equation wrt all names. The result will be one
    % multivariate derivative (`mode`==1) or several separate derivatives
    % (`mode`==Inf).
    deqtn = sydney.mydiffeqtn(THIS.eqtnF{ieq},mode,nmocc,tmocc,THIS.log);
    
    % Supply the list of functions with user derivatives as the last input
    % argument into `sydney.d`.
    deqtn = strrep(deqtn,'$userdifflist$',userdifflist);
    
    % Store strings; the strings are coverted to anonymous functions later.
    THIS.deqtnF{ieq} = deqtn;
    
    % Create function for evaluating the constant term in each equation in
    % linear models.
    if THIS.linear && THIS.eqtntype(ieq) <= 2
        ceqtn = myconsteqtn(THIS,THIS.eqtnF{ieq});
        THIS.ceqtnF{ieq} = ceqtn;
    end
    
end

end