function this = mysubsalt(this,lhs,obj,rhs)
% mysubsalt  [Not a public function] Implement SUBSREF and SUBSASGN for model
% objects with multiple parameterisations.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if nargin == 2
    
    % Subscripted reference this(lhs).
    this = mysubsalt@metaobj(this,lhs);
    this.eigval = this.eigval(1,:,lhs);
    this.icondix = this.icondix(1,:,lhs);
    for i = 1 : length(this.solution)
        this.solution{i} = this.solution{i}(:,:,lhs);
    end
    for i = 1 : length(this.Expand)
        this.Expand{i} = this.Expand{i}(:,:,lhs);
    end
    
elseif nargin == 3 && isempty(obj)
    
    % Empty subscripted assignment this(lhs) = [].
    this = mysubsalt@metaobj(this,lhs,obj);
    this.Assign(:,:,lhs) = [];
    this.stdcorr(:,:,lhs) = [];
    this.eigval(:,:,lhs) = [];
    this.icondix(:,:,lhs) = [];
    for i = 1 : length(this.solution)
        this.solution{i}(:,:,lhs) = [];
    end
    for i = 1 : length(this.Expand)
        this.Expand{i}(:,:,lhs) = [];
    end
    
elseif nargin == 4 && strcmp(class(this),class(obj))
    
    % Proper subscripted assignment this(lhs) = obj(rhs).
    this = mysubsalt@metaobj(this,lhs,obj,rhs);
    this.eigval(1,:,lhs) = obj.eigval(1,:,rhs);
    this.icondix(1,:,lhs) = obj.icondix(1,:,rhs);
    for i = 1 : length(this.solution)
        this.solution{i}(:,:,lhs) = obj.solution{i}(:,:,rhs);
    end
    for i = 1 : length(this.Expand)
        this.Expand{i}(:,:,lhs) = obj.Expand{i}(:,:,rhs);
    end
    
end

end