function [T,R,K,Z,H,D,U,Omg] = mysspace(m,ialt,expand)
% MYSSPACE  [Not a public function] General state space with forward expansion.
%
% Backed IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if ~exist('expand','var')
    expand = false;
end

if ~exist('ialt','var') || isinf(ialt)
    ialt = ':';
end

%**************************************************************************

T = m.solution{1}(:,:,ialt);
R = m.solution{2}(:,:,ialt); % Forward expansion.
K = m.solution{3}(:,:,ialt);
Z = m.solution{4}(:,:,ialt);
H = m.solution{5}(:,:,ialt);
D = m.solution{6}(:,:,ialt);
U = m.solution{7}(:,:,ialt);
nalt = size(T,3);

ne = sum(m.nametype == 3);
if ~expand
    R = R(:,1:ne);
end
if isempty(Z)
    nb = size(T,2);
    Z = zeros([0,nb,nalt]);
end
if isempty(H)
    H = zeros([0,ne,nalt]);
end
if isempty(D)
    D = zeros([0,1,nalt]);
end

if nargout > 7
    Omg = omega(m,[],ialt);
end

end