function THIS = mynonlineqtn(THIS)
% MYNONLINEQTN  [Not a public function] Create non-linear equations.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% Reset non-linear equations to empty strings.
THIS.eqtnN = cell(size(THIS.eqtnF));
THIS.eqtnN(:) = {''};

replacefunc = @do_replace; %#ok<NASGU>
for i = find(THIS.nonlin)
    eqtn = THIS.eqtnF{i};
    bkwcompatible();
    % Replace variables, shocks, and parameters.
    eqtn = regexprep(eqtn, ...
        'x\(:,(\d+),t([\+\-]\d+)?\)','${replacefunc($1,$2)}');
    % Replace references to steady states.
    eqtn = regexprep(eqtn, ...
        'L\(:,(\d+),t([\+\-]\d+)?\)','L($1)');
    THIS.eqtnN{i} = eqtn;
end

%**************************************************************************
    function out = do_replace(n,shift)
        n = str2double(n);
        if isempty(shift)
            shift = 0;
        else
            shift = str2double(shift);
        end
        if THIS.nametype(n) == 2
            % Transition variables.
            index = find(THIS.solutionid{2} == n+1i*shift);
            if ~isempty(index)
                time = 't';
            else
                index = find(THIS.solutionid{2} == n+1i*(shift+1));
                time = 't-1';
            end
            if THIS.log(n)
                out = sprintf('exp(x(%g,%s))',index,time);
            else
                out = sprintf('x(%g,%s)',index,time);
            end
        elseif THIS.nametype(n) == 3
            % Shocks.
            index = n - sum(THIS.nametype < 3);
            out = sprintf('e(%g,t)',index);
        else
            % Parameters.
            index = n - sum(THIS.nametype < 4);
            out = sprintf('p(%g)',index);
        end
    end
% do_replace().

%**************************************************************************
    function bkwcompatible()
        if isa(eqtn,'function_handle')
            eqtn = char(eqtn);
        end
        if eqtn(1) == '@'
            eqtn = regexprep(eqtn,'@\(.*?\)','');
        end
    end
% bkwcompatible().

end