function [TIME,NAME] = myfindoccur(THIS,EQ,TYPE)
% MYFINDOCCUR  [Not a public function] Find occurences of names in an equation.
%
% Backed IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

nname = length(THIS.name);
occur = THIS.occur(EQ,:);
occur = reshape(occur,[nname,size(THIS.occur,2)/nname]);
occur = occur.';

switch TYPE
    case 'variables_shocks'
        % Occurences of variables and shocks.
        occur = occur(:,THIS.nametype <= 3);
        [TIME,NAME] = find(occur);
    case 'variables(0)'
        % Occurences of current dates of variables.
        occur = occur(THIS.tzero,THIS.nametype <= 2);
        [TIME,NAME] = find(occur);
    case 'shocks'
        % Occurences of shocks.
        occur = occur(THIS.tzero,:);
        occur(:,THIS.nametype ~= 3) = false;
        [TIME,NAME] = find(occur);
    case 'parameters'
        % Occurences of parameters.
        occur = occur(THIS.tzero,:);
        occur(:,THIS.nametype ~= 4) = false;
        [TIME,NAME] = find(occur);
    otherwise
        TIME = zeros(1,0);
        NAME = zeros(1,0);
end



end
