function varargout = myfind(THIS,caller,varargin)
% MYFIND  [Not a public function] Find equations or names by their labels or descriptions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if strcmpi(caller,'findeqtn')
    list = THIS.eqtn;
    label = THIS.eqtnlabel;
else
    list = THIS.name;
    label = THIS.namelabel;
end

if isequal(varargin{1},'-rexp')
    isrexp = true;
    varargin(1) = [];
else
    isrexp = false;
end

varargout = cell(size(varargin));
for i = 1 : length(varargin)
    if isrexp
        index = regexp(label,sprintf('^%s$',varargin{i}));
        index = ~cellfun(@isempty,index);
        varargout{i} = list(index);
    elseif length(varargin{i}) > 3 ...
            && strcmp(varargin{i}(end-2:end),'...')
        index = strncmp(list,varargin{i}(1:end-3),length(varargin{i})-3);
        if any(index)
            varargout{i} = list(find(index,1));
        end
    else
        index = strcmp(label,varargin{i});
        if any(index)
            varargout{i} = list{find(index,1)};
        end
    end
end

end