function [THIS,A] = myfile2model(THIS,FNAME,OPT)
% myfile2model  [Not a public function] Translate model file to model object properties.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% Preparse the model file.
p = preparser(FNAME, ...
    'assign=',OPT.assign, ...
    'saveas=',OPT.saveas);

% Get and save carry-on files. They must be available before we run `parse`
% because we check for syntax error by evaluating the equations.
THIS.Export = p.Export;
export(THIS);

% Parse the model code proper.
[THIS,A] = myparse(THIS,p,OPT);
THIS.Comment = p.Comment;

% Mark the build.
THIS.build = irisversion();

end