function [R,Y,Jk] = myexpand(R,Y,k,Xa,Xf,Ru,J,Jk,Yu)
% myexpand  Expand one existing solution forward up to t+k.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% One of the non-lin add-factor matrices has been entered as [], do not
% expand non-lin add-factors.
isnonlin = true;
if all(size(Yu) == 0)
    Y = zeros(size(R,1),0);
    Yu = zeros(size(Ru,1),0);
    isnonlin = false;
end

ne = size(Ru,2);
nn = size(Yu,2);

if ne == 0 && nn == 0
    return
end

% Current expansion available up to t+k0.
k0 = size(R,2)/ne - 1;

% Check that R and Y are expanded to the same horizon.
if nn > 0 && k0 ~= size(Y,2)/nn - 1
    utils.error('internal', ...
        'Internal IRIS error.');
end

% Requested expansion not longer than the existing.
if k0 >= k
    return
end

% Pre-allocate NaNs.
R(:,end+(1:ne*(k-k0))) = NaN;
Y(:,end+(1:nn*(k-k0))) = NaN;

% Expansion matrices not available.
if any(any(isnan(Xa)))
    return
end

% Compute expansion.
for i = k0+1 : k
    Ra = -Xa*Jk*Ru; % Jk stores J^(k-1)
    Ya = -Xa*Jk*Yu;
    Jk = Jk*J;
    Rf = Xf*Jk*Ru;
    Yf = Xf*Jk*Yu;
    R(:,i*ne+(1:ne)) = [Rf;Ra];
    Y(:,i*nn+(1:nn)) = [Yf;Ya];
end

end