function EQTN = myconsteqtn(THIS,EQTN)
% MYCONSTEQTN  [Not a public function] Create an equation for evaluating constant terms in linear models.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% Replace all variables with 0 and all log-variables with 1.
replacefunc = @doreplace; %#ok<NASGU>

EQTN = regexprep(EQTN,'x\(:,(\d+),t[^\)]*\)', ...
    '${replacefunc($0,$1)}');
EQTN = sydney.myeqtn2symb(EQTN);
EQTN = sydney(EQTN);
EQTN = reduce(EQTN);
EQTN = char(EQTN);
EQTN = sydney.mysymb2eqtn(EQTN);
x = sscanf(EQTN,'%g');
if isnumericscalar(x) && isfinite(x)
    EQTN = x;
end

% Nested functions.

%**************************************************************************
    function c = doreplace(c0,c1)
        c = sscanf(c1,'%g');
        if THIS.nametype(c) <= 3
            if THIS.log(c)
                c = '1';
            else
                c = '0';
            end
        else
            c = c0;
        end
    end

end