function [S,RANGE,SELECT] = icrf(THIS,TIME,varargin)
% icrf  Initial-condition response functions.
%
% Syntax
% =======
%
%     S = icrf(M,NPER,...)
%     S = icrf(M,RANGE,...)
%
% Input arguments
% ================
%
% * `M` [ model ] - Model object for which the initial condition responses
% will be simulated.
%
% * `RANGE` [ numeric ] - Date range with the first date being the shock
% date.
%
% * `NPER` [ numeric ] - Number of periods.
%
% Output arguments
% =================
%
% * `S` [ struct ] - Database with initial condition response series.
%
% Options
% ========
%
% * `'delog='` [ *`true`* | `false` ] - Delogarithmise the responses for
% variables declared as `!variables:log`.
%
% * `'size='` [ numeric | *`1`* for linear models | *`log(1.01)`* for non-linear
% models ] - Size of the deviation in initial conditions.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright 2007-2012 Jaromir Benes.

% Parse options.
opt = passvalopt('model.icrf',varargin{:});

if ~isempty(opt.log)
    opt.delog = opt.log;
end

% TODO: Introduce `'select='` option.

%**************************************************************************

nb = size(THIS.solution{1},2);

% Set the size of the initial conditions.
if isempty(opt.size)
    % Default.
    if THIS.linear
        icsize = ones(1,nb);
    else
        icsize = ones(1,nb)*log(1.01);
    end
else
    % User supplied.
    icsize = ones(1,nb)*opt.size;
end

SELECT = get(THIS,'initcond');
SELECT = regexprep(SELECT,'log\((.*?)\)','$1','once');

func = @(T,R,K,Z,H,D,U,Omg,ialt,nper) ...
    timedom.icrf(T,[],[],Z,[],[],U,[], ...
    nper,icsize,THIS.icondix);

[S,RANGE] = myrf(THIS,TIME,func,SELECT,opt);

end