function varargout = failed(m,npath,sstatesuccess,fname)
% failed  Give access to the last failed model object.
%
% Syntax
% =======
%
%     M = model.failed()
%
% Output arguments
% =================
%
% * `M` [ numeric ] - The model object with the parameterisation that
% failed to converge on steady state or to solve during one of the
% following functions: [`model/estimate`](model/estimate),
% [`model/diffloglik`](model/diffloglik), [`model/fisher`](model/fisher).
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

persistent STORE;

if nargin == 0
   varargout{1} = STORE;
   return
end

STORE = m;

if ~sstatesuccess
   msg = 'current parameters do not produce steady state convergence';
else
   msg = 'current parameters produce ';
   if npath == 0
      msg = [msg,'no stable solution'];
   elseif npath == Inf
      msg = [msg,'multiple stable solutions'];
   elseif imag(npath) ~= 0
      msg = [msg,'complex derivatives'];
   elseif isnan(npath)
      msg = [msg,'NaN derivatives'];
   elseif npath == -1
      msg = [msg,'singularity in the state-space form'];
   end
end

error([...
   '%s failed because %s.\n',...
   'Type <a href="matlab: x = model.failed();">x = model.failed();</a> to get the model object that failed to solve.',...
   ],upper(fname),msg);

end
