function [dpack,naninit] = db2dp(m,d,range)
% db2dp  Convert database to model-specific datapack.
%
% Syntax
% =======
%
%     dp = db2dp(m,db,range)
%
% Input arguments
% ================
%
% * `m` [ model ] - Model object for which the datapack will be created.
%
% * `db` [ struct ] - Input database that will be converted to a datapack.
%
% * `range` [ numeric ] - Date range on which the datapack will be created.
%
% Output arguments
% =================
%
% * `dp` [ cell ] - Output datapack.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

range = range(1):range(end);
ny = size(m.solution{4},1);
nx = size(m.solution{1},1);
nb = size(m.solution{7},1);
nf = nx - nb;
ne = size(m.solution{2},2);

dpack = cell([1,4]);

dpack{1} = datarequest('y',m,d,range);
ndata = size(dpack{1},3);
dpack{1} = [nan([ny,1,ndata]),dpack{1}];

dpack{2} = datarequest('x',m,d,range);
ndata = size(dpack{2},3);
[xinit,naninit] = datarequest('xinit',m,d,range);
dpack{2} = [[nan([nf,1,ndata]);xinit],dpack{2}];

dpack{3} = datarequest('e',m,d,range);
ndata = size(dpack{3},3);
dpack{3} = [nan([ne,1,ndata]),dpack{3}];

dpack{4} = range(1)-1 : range(end);

end
