function [flag,index] = chk(m,alt,varargin)
    % chk  Check for missing or inconsistent values assigned within the model object.
    %
    % Backed IRIS function.
    % No help provided.
    
    % -IRIS Toolbox.
    % -Copyright (c) 2007-2012 Jaromir Benes.
    
    %**********************************************************************
    
    if isequal(alt,Inf)
        alt = 1 : size(m.Assign,3);
    end
    
    for i = 1 : length(varargin)
        switch varargin{1}
            case 'log'
                realsmall = getrealsmall();
                index = find(m.log);
                index = index(any(m.Assign(1,index,alt) <= realsmall,3));
                flag = isempty(index);
                if ~flag
                    utils.warning('model',...
                        ['This log-linear variable ', ...
                        'has non-positive steady state: ''%s''.'], ...
                        m.name{index});
                end
            case 'parameters'
                % Throw warning if some parameters are not assigned.
                [flag,list] = isnan(m,'parameters',alt);
                if flag
                    utils.warning('model', ...
                        'This parameter is not assigned: ''%s''.', ...
                        list{:});
                end
            case 'sstate'
                % Throw warning if some steady states are not assigned.
                [flag,list] = isnan(m,'sstate',alt);
                if flag
                    utils.warning('model', ...
                        ['Steady state is not available ', ...
                        'for this variable: ''%s''.'], ...
                        list{:});
                end
        end
    end
    
end
