function [this,varargout] = assign(varargin)
% assign  Assign parameters, steady states, std deviations or cross-correlations.
%
% Syntax
% =======
%
%     [M,ASSIGNED] = assign(M,P)
%     [M,ASSIGNED] = assign(M,NAME,VALUE,NAME,VALUE,...)
%     [M,ASSIGNED] = assign(M,LIST,VALUES)
%
% Syntax for fast assign
% =======================
%
%     % Initialise
%     assign(M,LIST);
%
%     % Fast assign
%     M = assign(M,VALUES);
%     ...
%     M = assign(M,VALUES);
%     ...
%
% Syntax for assigning only steady-state levels
% ==============================================
%
%     M = assign(M,'-level',...)
%
% Syntax for assignin only steady-state growth rates
% ===================================================
%
%     M = assign(M,'-growth',...)
%
% Input arguments
% ================
%
% * `M` [ model ] - Model object.
%
% * `P` [ struct | model ] - Database whose fields refer to parameter
% names, variable names, std deviations, or cross-correlations; or another
% model object.
%
% * `NAME` [ char ] - A parameter name, variable name, std
% deviation, cross-correlation, or a regular expression that will be
% matched against model names.
%
% * `VALUE` [ numeric ] - A value (or a vector of values in case of
% multiple parameterisations) that will be assigned.
%
% * `LIST` [ cellstr ] - A list of parameter names, variable names, std
% deviations, or cross-correlations.
%
% * `VALUES` [ numeric ] - A vector of values.
%
% Output arguments
% =================
%
% * `M` [ model ] - Model object with newly assigned parameters and/or
% steady states.
%
% * `ASSIGNED` [ cellstr | `Inf` ] - List of actually assigned parameter
% names, variables names (steady states), std deviations, and
% cross-correlations; `Inf` indicates that all values has been assigned
% from another model object.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[this,varargout{1:nargout-1}] = assign@metaobj(varargin{:});

% Housekeeping.

% Steady states of shocks can only be zero.
this.Assign(1,this.nametype == 3,:) = 0;

% Only measurement and transition variables can have imaginary parts.
this.Assign(1,this.nametype > 2,:) = ...
    real(this.Assign(1,this.nametype > 2,:));

end