function X = subsref(THIS,S)
% subsref  Subscripted reference for model and syeq objects.
%
% Syntax for retrieving object with subset of parameterisations
% ==============================================================
%
%     M(INDEX)
%
% Syntax for retrieving parameters or steady-state values
% ========================================================
%
%     M.NAME
%
% Syntax to retrieve a std deviation or a cross-correlation of shocks
% ====================================================================
%
%     M.STD_NAME
%     M.CORR_NAME1__NAME2
%
% Note that a double underscore is used to separate the names of shocks in
% correlation coefficients.
%
% Input arguments
% ================
%
% * `M` [ model | syeq ] - Model or syeq object.
%
% * `INDEX` [ numeric | logical ] - Index of requested parameterisations.
%
% * `NAME`, `NAME1`, `NAME2` [ char ] - Name of a variable, shock, or
% parameter.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

nalt = size(THIS.Assign,3);
S = utils.altersubs(S,nalt,class(THIS));
thisclass = class(THIS);

% Fast reference `m.name`.
if strcmp(S(1).type,'.') && ischar(S(1).subs)
    name = S(1).subs;
    [assignpos,stdcorrpos] = mynameposition(THIS,{name});
    if isnan(assignpos) && isnan(stdcorrpos)
        utils.error('metaobj', ...
            ['This name does not exist in the ',thisclass, ...
            ' object: ''%s''.'], ...
            name);
    end
    if ~isnan(assignpos)
        % Regular parameter or steady state.
        X = permute(THIS.Assign(1,assignpos,:),[1,3,2]);
    else
        % Std or corr.
        X = permute(THIS.stdcorr(1,stdcorrpos,:),[1,3,2]);
    end
    S(1) = [];
    if ~isempty(S)
        X = subsref(X,S);
    end
elseif strcmp(S(1).type,'()') && length(S(1).subs) == 1 ...
        && isnumeric(S(1).subs{1})
    % m(index) or m{index}
    index = S(1).subs{1};
    if any(index > nalt)
        utils.error('metaobj', ...
            'Index exceeds number of parameterisations.');
    end
    X = mysubsalt(THIS,index);
end

end