function [X,FLAG] = specget(THIS,QUERY)
% specget  [Not a public function] GET method for metaobj objects.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

X = [];
FLAG = true;

QUERY = xxalias(QUERY);
nalt = size(THIS.Assign,3);
ne = sum(THIS.nametype == 3);

switch QUERY
    
    case 'file'
        X = THIS.fname;
        
    case {'carryon','export'}
        X = THIS.Export;
        
    case 'list'
        X = THIS.name;
        
    case {'ylist','xlist','elist','plist'}
        type = find(QUERY(1) == 'yxep');
        X = THIS.name(THIS.nametype == type);
        
    case {'ydescript','xdescript','edescript','pdescript'}
        index = find(QUERY(1) == 'yxep');
        X = THIS.namelabel(THIS.nametype == index);
        
    case 'descript'
        X = cell2struct(THIS.namelabel,THIS.name,2);
        
    case 'param'
        X = xxgetparam(THIS);
        
    case 'std'
        [ans,ans,X] = xxgetstd(THIS);
        
    case {'corr','nonzerocorr'}
        [ans,ans,X] = xxgetcorr(THIS,QUERY);
        
    case 'stdlist'
        elist = THIS.name(THIS.nametype == 3);
        X = regexprep(elist,'^.','std_$0','once');
        
    case 'corrlist'
        X = mycorrnames(THIS);
        
    case 'stdcorrlist'
        elist = THIS.name(THIS.nametype == 3);
        X = regexprep(elist,'^.','std_$0','once');
        X = [X,mycorrnames(THIS)];
        
    case {'log','islog'}
        X = struct();
        for i = find(THIS.nametype <= 3);
            X.(THIS.name{i}) = THIS.log(i);
        end
        
    case {'loglist'}
        X = THIS.name(THIS.log & THIS.nametype <= 3);
        
    case {'nonloglist'}
        X = THIS.name(~THIS.log & THIS.nametype <= 3);
        
    case {'covmat','omega'}
        X = omega(THIS);
        
    case {'stdvec'}
        X = permute(THIS.stdcorr(1,1:ne,:),[2,3,1]);
        
    case {'stdcorrvec'}
        X = permute(THIS.stdcorr,[2,3,1]);
        
    case {'nalt'}
        X = nalt;
        
    case {'nametype'}
        X = THIS.nametype;
        
    otherwise
        FLAG = false;
        
end

end

% Subfunctions.

%**************************************************************************
function query = xxalias(query)
% Alias list, name, names.
query = regexprep(query,'names?$','list');
% Alias comment, comments, tag, tags.
query = regexprep(query, ...
    'descriptions?|descripts?|descr?|comments?|tags?|annotations?', ...
    'descript');
% Alias param, params, parameter, parameters.
query = regexprep(query,'param.*','param');
% Alias corr, corrs, correlation, correlations
query = regexprep(query,'corrs?|correlations?','corr');
% Alias nalt, nalter.
query = regexprep(query,'nalt(er)?','nalt');
end
% xxalias().

%**************************************************************************
function [list,values,x] = xxgetstd(this)
ne = sum(this.nametype == 3);
values = this.stdcorr(1,1:ne,:);
list = this.name(this.nametype == 3);
list = regexprep(list,'^.','std_$0','once');
if nargout > 2
    x = xxnum2struct(values,list);
end
end
% xxgetstd().

%**************************************************************************
function [list,values,x] = xxgetcorr(this,query)
ne = sum(this.nametype == 3);
nalt = size(this.Assign,3);
pos = tril(ones(ne),-1) == 1;
R = zeros(ne,ne,nalt);
for ialt = 1 : nalt
    temp = zeros(ne);
    temp(pos) = this.stdcorr(1,ne+1:end,ialt);
    R(:,:,ialt) = temp;
end
if isequal(query,'nonzerocorr')
    [i,j] = find(any(R ~= 0,3));
else
    [i,j] = find(pos);
end
elist = this.name(this.nametype == 3);
x = struct();
ni = length(i);
list = cell(1,ni);
values = zeros(1,ni,nalt);
for k = 1 : length(i)
    name = ['corr_',elist{j(k)},'__',elist{i(k)}];
    list{k} = name;
    values(1,k,:) = R(i(k),j(k),:);
    x.(name) = permute(R(i(k),j(k),:),[2,3,1]);
end
end
% xxgetcorr().

%**************************************************************************
function x = xxgetparam(this)
assign = this.Assign(1,this.nametype == 4,:);
assignlist = this.name(this.nametype == 4);
[stdlist,std] = xxgetstd(this);
[corrlist,corr] = xxgetcorr(this,'nonzerocorr');
x = xxnum2struct([assign,std,corr],[assignlist,stdlist,corrlist]);
end
% xxgetparam().

%**************************************************************************
function s = xxnum2struct(x,list)
s = cell2struct( ...
    num2cell(permute(x,[2,3,1]),2), ...
    list(:),1);
end
% xxnum2struct().
