function varargout  = omega(THIS,OMG,IALT)
% omega  Get or set the covariance matrix of shocks.
%
% Syntax for getting covariance matrix
% =========================================
%
%     OMG = omega(M)
%
% Syntax for setting covariance matrix
% =====================================
%
%     M = omega(M,OMG)
%
% Input arguments
% ================
%
% * `M` [ model | bkwmodel ] - Model or bkwmodel object.
%
% * `OMG` [ numeric ] - Covariance matrix that will be converted to new
% values for std deviations and cross-corr coefficients.
%
% Output arguments
% =================
%
% * `OMG` [ numeric ] - Covariance matrix of shocks or residuals based on
% the currently assigned std deviations and cross-correlation coefficients.
%
% * `M` [ model | bkwmodel ] - Model or bkwmodel object with new values
% for std deviations and cross-corr coefficients based on the input
% covariance matrix.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%#ok<*VUNUS>
%#ok<*CTCH>

try
    OMG; 
catch
    OMG = [];
end

try
    if isequal(IALT,Inf)
        IALT = ':';
    end
catch
    IALT = ':';
end

%**************************************************************************

if isempty(OMG)
    % Create Omega from stdcorr.
    ne = sum(THIS.nametype == 3);
    stdcorr = permute(THIS.stdcorr(1,:,IALT),[2,3,1]);
    OMG = covfun.stdcorr2cov(stdcorr,ne);
    varargout{1} = OMG;
    varargout{2} = stdcorr;
else
    % Assign stdcorr from Omega.
    OMG = OMG(:,:,:);
    stdcorr = covfun.cov2stdcorr(OMG);
    stdcorr = permute(stdcorr,[3,1,2]);
    nalt = size(THIS.stdcorr(1,:,IALT),3);
    if size(stdcorr,3) < nalt
        stdcorr(1,:,end+1:nalt) = stdcorr(1,:,end*ones([1,nalt-end]));
    end
    THIS.stdcorr(1,:,IALT) = stdcorr(:,:,IALT);
    varargout{1} = THIS;
end

end