function THIS = mysubsalt(THIS,LHS,OBJ,RHS)
% mysubsalt  [Not a public function] Implement SUBSREF and SUBSASGN for
% metaobj with multiple parameterisations.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if nargin == 2
    
    % Subscripted reference `THIS(LHS)`.
    THIS.Assign = THIS.Assign(1,:,LHS);
    THIS.stdcorr = THIS.stdcorr(1,:,LHS);
    
elseif nargin == 3 && isempty(OBJ)
    
    % Empty subscripted assignment `THIS(LHS) = []`.
    THIS.Assign(:,:,LHS) = [];
    THIS.stdcorr(:,:,LHS) = [];
    
elseif nargin == 4 && strcmp(class(THIS),class(OBJ))
    
    % Proper subscripted assignment `THIS(LHS) = OBJ(RHS)`.
    THIS.Assign(1,:,LHS) = OBJ.Assign(1,:,RHS);
    THIS.stdcorr(1,:,LHS) = OBJ.stdcorr(1,:,RHS);
    
end

end