function INDEX = mystdcorrindex(THIS,NAME)
% mycorrindex  [Not a public function] Positions of std deviations and cross-correlations.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

% `INDEX` is a 1-by-N logical index with N = ne*(ne-1)/2 with true for each
% correlation name matched in char `NAME`. `NAME` can be a plain string or
% a regular expression.

%**************************************************************************

INDEX = false(1,size(THIS.stdcorr,2));
elist = THIS.name(THIS.nametype == 3);
ne = length(elist);

if length(NAME) >= 5 && strncmp(NAME,'std_',4)
    
    % Position of a std deviation.
    
    stdlist = regexprep(elist,'.*','std_$0');
    INDEX(1:ne) = strfun.strcmporregexp(stdlist,NAME);
    
elseif length(NAME) >= 9 && strncmp(NAME,'corr_',5)
    
    % Position of a corr coefficient.
    
    % Break down the corr name corr_SHOCK1__SHOCK2 into SHOCK1 and SHOCK2.
    shocknames = regexp(NAME(6:end),'^(.*?)__([^_].*)$','tokens','once');
    
    if isempty(shocknames) ...
            || isempty(shocknames{1}) || isempty(shocknames{2})
        return
    end
    
    % Try to find the positions of the shock names.
    index1 = strfun.strcmporregexp(elist,shocknames{1});
    index2 = strfun.strcmporregexp(elist,shocknames{2});
    
    % Place the shocks in the cross-correlation matrix.
    corrmat = false(ne);
    corrmat(index1,index2) = true;
    corrmat(index2,index1) = true;
    corrmat = tril(corrmat,-1);
    
    [i,j] = find(corrmat);
    for k = 1 : length(i)
        p = ne + sum((ne-1):-1:(ne-j(k)+1)) + (i(k)-j(k));
        INDEX(p) = true;
    end
    
end

end