function STDCORR = mycombinestdcorr(THISSTDCORR,USRSTDCORR,NPER)
% mycombinestdcorr  [Not a public function] Combine model stdcorr vector
% with user-supplied time-varying stdcorr.

usrstdcorrix = ~isnan(USRSTDCORR);
THISSTDCORR = THISSTDCORR(:);
if any(usrstdcorrix(:))
    lastuser = max(1,size(USRSTDCORR,2));
    STDCORR = THISSTDCORR(:,ones(1,lastuser));
    STDCORR(usrstdcorrix) = USRSTDCORR(usrstdcorrix);
    % Add the model stdcorrs if the last user-supplied data point is before
    % the end of the sample.
    if size(STDCORR,2) < NPER
        STDCORR(:,end+1) = THISSTDCORR;
    end
else
    STDCORR = THISSTDCORR;
end

end