classdef metaobj
    % metaobj  [Not a public class] Base class for model type of objects.
    %
    % Backend IRIS class.
    % No help provided.
    
    % -IRIS Toolbox.
    % -Copyright (c) 2007-2012 Jaromir Benes.
    
    properties (Hidden)
        fname = '';
        build = [];
        Export = struct('filename',{},'content',{});
        name = cell(1,0);
        nametype = zeros(1,0);
        namelabel = cell(1,0);
        Assign = zeros(1,0);
        stdcorr = zeros(1,0);
        log = false(1,0);
    end
    
    methods
        function this = metaobj(varargin)
        end
        
        function export(this)
            % export  Save carry-around files on the disk.
            %
            % Syntax
            % =======
            %
            %     export(M)
            %
            % Input arguments
            % ================
            %
            % * `M` [ model ] - Model object whose carry-around m-files (written in
            % underlying the model file) will be saved on the disk.
            %
            % Description
            % ============
            %
            % See the IRIS model language keyword [`!export`](modellang/export) for
            % help on how to write carry-around m-files in model files.
            %
            % Example
            % ========
            %
            
            % -IRIS Toolbox.
            % -Copyright (c) 2007-2012 Jaromir Benes.
            
            preparser.export(this,this.Export);
        end
        
        varargout = assign(varargin)
        varargout = emptydb(varargin)
        varargout = length(varargin)
        varargout = omega(varargin)
        varargout = stdscale(varargin)        
        varargout = subsasgn(varargin)
        varargout = subsref(varargin)
        
    end
    
    methods (Hidden)
        varargout = mynameposition(varargin)
        varargout = size(varargin)
        varargout = specget(varargin)
        varargout = myfname(varargin)
    end
    
    methods (Access=protected,Hidden)
        varargout = iscompatible(varargin)
        varargout = mycorrnames(varargin)
        varargout = mystdcorrindex(varargin)
        varargout = mytune2stdcorr(varargin)
        varargout = mysubsalt(varargin)
    end
    
    methods (Static,Hidden)
        varargout = mycombinestdcorr(varargin)
    end
    
end