function [X,FLAG] = specget(THIS,QUERY)
% SPECGET  [Not a public function] Implement GET method for esteq objects.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[X,FLAG] = specget@metaobj(THIS,QUERY);
if FLAG
    return
end

QUERY = xxalias(QUERY);

X = [];
FLAG = true;

switch QUERY
    
    case 'eqtn'
        X = THIS.eqtn;
        
    case 'nalt'
        X = size(THIS.Assign,3);
        
    case 'maxlag'
        X = -THIS.maxlag;
        
    case 'maxlead'
        X = THIS.maxlead;
        
    otherwise
        FLAG = false;
        
end

end

% Subfunctions.

%**************************************************************************
function QUERY = xxalias(QUERY)
% Alias equation, equations, eqtn, eqtns.
QUERY = regexprep(QUERY,'eqtns?|equations?','eqtn');
% Alias label, labels.
QUERY = regexprep(QUERY,'labels','label');
% Alias nalt, nalter.
QUERY = regexprep(QUERY,'nalt(er)?','nalt');
% Alias corr, corrs, correlation, correlations
QUERY = regexprep(QUERY,'corrs?|correlations?','corr');
end
% xxalias().