classdef esteq < metaobj & userdataobj & estimateobj
    
    properties
        eqtn = {};
        eqtneval = [];
        maxlag = NaN;
        maxlead = NaN;
    end
    
    methods
        
        function THIS = esteq(varargin)
            % esteq  Create new esteq object.
            %
            % Syntax
            % =======
            %
            %     Q = esteq(EQTN,PAR);
            %
            % Input arguments
            % ================
            %
            % * `EQTN` [ char | cellstr ] - Equation or or list of equations.
            %
            % * `PAR` [ char | cellstr ] - List of parameter names.
            %
            % Output arguments
            % =================
            %
            % * `Q` [ esteq ] - Esteq object.
            %
            % Description
            % ============
            %
            % Example
            % ========
            %
            
            % -IRIS Toolbox.
            % -Copyright (c) 2007-2012 Jaromir Benes.
            
            %**************************************************************************
            
            THIS = THIS@metaobj();
            THIS = THIS@estimateobj();
            if nargin == 0
                return
            end
            
            if nargin == 1 && isa(varargin{1},'esteq')
                THIS = varargin{1};
                return
            end
            
            if nargin == 2 ...
                    && (iscellstr(varargin{1}) || ischar(varargin{1})) ...
                    && (iscellstr(varargin{2}) || ischar(varargin{2}))
                if ischar(varargin{1})
                    varargin{1} = regexp(varargin{1},'[^;]+','match');
                end
                if ischar(varargin{2})
                    varargin{2} = regexp(varargin{2},'\<[a-zA-z]\w*\>','match');
                end
                THIS = myparse(THIS,varargin{1},varargin{2});
                return
            end
            
        end
        
        varargout = assign(varargin)
        varargout = estimate(varargin)
        varargout = eval(varargin)
        varargout = subsasgn(varargin)
        varargout = subsref(varargin)
        
    end
    
    methods (Hidden)
        varargout = myprederror(varargin)
        varargout = myupdatemodel(varargin)
    end
    
    methods (Access=protected,Hidden)
        varargout = mydatarequest(varargin)
        varargout = myestimstruct(varargin)
        varargout = myparse(varargin)
    end
    
end