function [THIS,asgnd] = assign(THIS,varargin)

if length(varargin) == 1 && isstruct(varargin{1})
    s = varargin{1};
elseif ~isempty(varargin) && iscellstr(varargin(1:2:end))
    varargin(1:2:end) = strrep(varargin(1:2:end),'=','');
    s = cell2struct(varargin(2:2:end),varargin(1:2:end),2);
end

nname = length(THIS.name);
isasgnd = false(1,nname);
for i = 1 : nname
    name = THIS.name{i};
    if isfield(s,name) && isnumericscalar(s.(name))
        THIS.Assign(1,i) = s.(name);
        isasgnd(i) = true;
    end 
end
asgnd = THIS.name(isasgnd);

end