function A = system(this,x,t,dolog)

if ~exist('dolog','var')
   dolog = true;
end

nt = size(this.occur,3);
maxlag = nt - 1;
% Number of endogenous variables and endogenous equations.
n = sum(this.nametype == 1);

D = zeros([n,n*nt]);
for eq = 1 : n
   [name,time] = ...
      find(permute(this.occur(eq,this.nametype == 1,:),[2,3,1]));
   name = name.';
   time = time.';
   lag = time - 1;
   d = this.deqtn{eq}(x,t);
   if dolog && any(this.log(name))
      nocc = length(name);
      for i = 1 : nocc
         if this.log(name(i))
            d(i) = d(i) * x(name(i),t-lag(i));
         end
      end
   end
   D(eq,(time-1)*n+name) = d;
end

nadd = n*(maxlag-1);
A = D(:,1:n);
B = D(:,n+1:end);
A(end+(1:nadd),end+(1:nadd)) = eye(nadd);
B(end+(1:nadd),:) = -eye([nadd,nadd+n]);

%{
if any(any(A(1:n,~this.systemkeep))) ...
      || any(any(B(1:n,~this.systemkeep)))
   utils.error('bkwmodel', ...
      'Internal inconsistency in system matrices.');
end
%}

% A x(t) + B x(t-1) + C e(t) = 0;
A = A(this.systemkeep,this.systemkeep);
if nargout == 1
   return
end

B = B(this.systemkeep,this.systemkeep);
if nargout == 2
   return
end

C = double(this.occur(:,this.nametype == 3,1));
C(end+(1:nadd),:) = 0;
C = C(this.systemkeep,:);

% x(t) = T x(t-1) + R e(t);
T = -A\B;
R = -A(1:n,1:n)\C(1:n,:);
R(end+(1:nadd),:) = 0;
R = R(this.systemkeep,:);

end
