function this = horzcat(this,varargin)
% horzcat  Combine two compatible bkwmodel objects in one object with multiple parameterisations.
%
% Syntax
% =======
%
%     b = [b1,b2,...]
%
% Input arguments
% ================
%
% * `b1`, `b2` [ bkwmodel ] - Compatible bkwmodel objects that will be
% combined; the input models must be based on the same model file.
%
% Output arguments
% =================
%
% * `b` [ bkwmodel ] - Output kbwmodel object that combines the input
% bkwmodel objects as multiple parameterisations.
%
% Description
% ============
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if nargin == 1
   return
end

s = struct();
for i = 1 : numel(varargin)
   nalt = size(this.Assign,3);
   newnalt = size(varargin{1}.Assign,3);
   index = nalt + (1 : newnalt); 
   s.type = '()';
   s.subs = {index};
   this = subsasgn(this,s,varargin{1});
end

end