classdef bkwmodel < metaobj & userdataobj & estimateobj
% bkwmodel  Non-linear backward-looking model (bkwmodel) objects and functions.
%
% NOT DOCUMENTED YET.
%

% Bkwmodel methods:
%
% Constructor
% ============
%
% * bkwmodel - Non-linear backward-looking model (bkwmodel) objects and functions.
%
% Getting on-line help on model functions
% ========================================
%
%     help bkwmodel
%     help bkwmodel/function_name
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

   properties
      %fname = '';
      %Export = {};
      %name = {};
      %nametype = [];
      %namelabel = {};
      %Assign = [];
      %stdcorr = [];
      %log = [];
      eqtnUsr = {};
      eqtnlabel = {};
      eqtnEval = {};
      eqtnEvalAll = [];
      eqtnEvalAllRes = [];
      eqtnEvalRes = {};
      eqtnEvalIdent = {};
      deqtn = {};
      identity = [];
      occur = false(0);
      systemid = [];
      systemkeep = [];
      systemxi = [];
      systemlog = [];
   end
      
   methods
      function this = bkwmodel(varargin)
         if nargin == 0
            return
         end
         if nargin >= 1 && ischar(varargin{1})
            fname = varargin{1};
            varargin(1) = [];
            options = passvalopt('bkwmodel.bkwmodel',varargin{:});
            p = preparser(fname, ...
                'assign',options.assign,'saveas',options.saveas);
            [this,a] = parse(this,p,options.assign);
            this.Export = p.Export;
            export(this);
            this = symbdiff(this);
            this = eqtn2func(this);
            this = metasystem(this);
            this = assign(this,a);
         end
      end
      
      varargout = alter(varargin)
      varargout = assign(varargin)
      varargout = db2dp(varargin)
      varargout = dp2db(varargin)
      varargout = estimate(varargin)
      varargout = get(varargin)
      varargout = isempty(varargin)
      varargout = length(varargin)
      varargout = parse(varargin)
      varargout = residuals(varargin)
      varargout = simulate(varargin)
      varargout = size(varargin)
   end
   
   methods (Hidden)
      varargout = and(varargin)
      varargout = end(varargin)
      varargout = fieldnames(varargin)
      varargout = myanchors(varargin)
      varargout = horzcat(varargin)
      varargout = kalman(varargin)
      varargout = specget(varargin)
      varargout = system(varargin)
   end
   
   methods (Access=protected,Hidden)
      varargout = symbdiff(varargin)
      varargout = metasystem(varargin)
   end
   
end