function warning(code,list,varargin)

if ~iswarning('var') || ~iswarning('rvar') || ~iswarning('svar')
   return
end

switch code
   case -1
      msg = 'Test warning.';
   case 2
      msg = '%s for non-orthogonal innovations.';
   case 3
      msg = 'LR-tested VAR or VAR models have identical numbers of hyperparameters.';
   case 7
      msg = 'Cannot reset mean for non-stationary parameterisation(s)%s.';
   case 8
      msg = 'Cannot demean VAR(s) with non-stationary parameterisation(s)%s.';
   case 9
      msg = 'Shock response function for reduced-form VAR.';
   case 10
      msg = 'Unable to compute ACF for explosive parameterisation(s)%s.';
   case 11
      msg = 'Insufficient number of observations to extend data.';
   case 12
      msg = 'Cannot compute backward VAR for non-statinonary parameterisation(s)%s.';
   case 13
      msg = 'Input time series contain(s) within-sample NaNs.'; 
   case 14
      msg = 'Some of the initial conditions for resampling are NaN: %s.';
   case 15
      msg = 'Some of the resampled residuals are NaN: %s.';
      
end

if nargin == 1
   list = {};
end

printmsg('VAR','warning',msg,list,code);

end