function Phi = vma(this,nper)
% vma  Matrices describing the VMA representation of a VAR process.
%
% Syntax
% =======
%
%     PHI = vma(V,N)
%
% Input arguments
% ================
%
% * `V` [ VAR ] - VAR object for which the VMA matrices will be computed.
%
% * `N` [ numeric ] - Order up to which the VMA matrices will be computed.
%
% Output arguments
% =================
%
% * `PHI` [ numeric ] - VMA matrices.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

P = inputParser();
P.addRequired('w',@(x) isa(x,'VAR'));
P.addRequired('n',@isnumericscalar);
P.parse(this,n);

%**************************************************************************

[A,B] = mysystem(this);
Phi = timedom.var2vma(A,B,nper);

end
