function this = subsasgn(this,s,x)
% subsasgn  Subscripted assignment for VAR objects.
%
% Syntax to assign parameterisations from other VAR object
% =========================================================
%
%     v(index) = w
%
% Syntax to delete specified parameterisations
% =============================================
%
%     v(index) = []
%
% Input arguments
% ================
%
% * `v` [ VAR ] - VAR object.
%
% * `index` [ numeric ] - Index of parameterisations that will be assigned
% or deleted.
%
% * `w` [ VAR ] - VAR object compatible with `m` whose parameterisations
% will be assigned (copied) into `v`.
%
% Output arguments
% =================
%
% * v [ model ] - VAR object with newly assigned or deleted parameterisations,
%
% Description
% ============
%
% Example
% ========
%
% Expand the number of parameterisations in a VAR object that has
% initially just one parameterisation:
%
%     v(1:10) = v;
%
% The parameterisation is simply copied ten times within the VAR object.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if length(s) == 1 ...
        && any(strcmp(s.type,{'()','{}'})) ...
        && length(s.subs) == 1
    if strcmp(class(this),class(x)) || isempty(x)
        nalt = length(this);
        if ischar(s.subs) && strcmp(s.subs{1},':');
            lhs = 1 : nalt;
        else
            lhs = s.subs{1};
        end
        if isempty(x)
            this = mysubsalt(this,lhs,[]);
        else
            nx = length(x);
            if nx == 1
                if islogical(lhs) && sum(lhs) > 1
                    rhs = ones(1,sum(lhs));
                elseif length(lhs) > 1
                    rhs = ones(1,length(lhs));
                else
                    rhs = 1;
                end
            else
                rhs = 1 : nx;
            end
            this = mysubsalt(this,lhs,x,rhs);
        end
    else
        utils.error(class(this),'Invalid assignment to a VAR object.');
    end
else
    % Dot reference.
    this = builtin('subsasgn',this,s,x);
end

end