function [T,R,k,Z,H,d,U,Omg,alt] = sspace(this,varargin)
% sspace  Quasi-triangular state-space representation of VAR.
%
% Syntax
% =======
%
%     [T,R,K,Z,H,D,Omg] = sspace(w,...)
%
% Input arguments
% ================
%
% * `w` [ VAR ] - VAR object.
%
% Output arguments
% =================
%
% * `T` [ numeric ] - Transition matrix.
%
% * `R` [ numeric ] - Matrix at the shock vector in transition equations.
%
% * `K` [ numeric ] - Constant vector in transition equations.
%
% * `Z` [ numeric ] - Matrix mapping transition variables to measurement
% variables.
%
% * `H` [ numeric ] - Matrix at the shock vector in measurement
% equations.
%
% * `D` [ numeric ] - Constant vector in measurement equations.
%
% * `U` [ numeric ] - Transformation matrix for predetermined variables.
%
% * `Omega` [ numeric ] - Covariance matrix of shocks.
%
% Description
% ============
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright 2007-2012 Jaromir Benes.

if ~isempty(varargin) && ~ischar(varargin{1})
   alt = varargin{1};
   varargin(1) = []; %#ok<NASGU>
else
   alt = ':';
end

%**************************************************************************

[ny,p] = sizeof(this);

T = this.T(:,:,alt);
U = this.U(:,:,alt);
R = permute(U(1:ny,:,:),[2,1,3]);
K = this.K(:,alt);
n3 = size(T,3);

% Constant term.
k = zeros([ny*p,1,n3]);
for i = 1 : n3
   k(:,1,i) = transpose(U(1:ny,:,i))*K(:,1,i);
end

Z = U(1:ny,:,:);

H = zeros([ny,ny,n3]);
d = zeros([ny,1,n3]);

Omg = this.Omega(:,:,alt);

end