function [x,flag] = specget(this,query)
% SPECGET  [Not a public function] Implement GET method for VAR objects.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

x = [];
flag = true;

[ny,p,nalt] = sizeof(this);
realsmall = getrealsmall();

switch lower(query)
    case {'a','a*'}
        if all(size(this.A) == 0)
            x = [];
        else
            x = poly.var2poly(this.A);
        end
        if isequal(query,'a*')
            x = -x(:,:,2:end,:);
        end
    case 'g'
        x = this.G;
    case 't'
        x = this.T;
    case 'u'
        x = this.U;
    case {'const','c','k'}
        x = this.K;
    case {'omg','omega','cove','covresiduals'}
        x = this.Omega;
    case {'sgm','sigma','covp','covparameters'}
        x = this.Sigma;
    case 'aic'
        x = this.aic;
    case 'sbc'
        x = this.sbc;
    case {'eig','eigval','roots'}
        x = this.eigval;
    case {'stableroots','explosiveroots','unstableroots','unitroots'}
        switch query
            case 'stableroots'
                test = @(x) abs(x) < (1 - realsmall);
            case {'explosiveroots','unstableroots'}
                test = @(x) abs(x) > (1 + realsmall);
            case 'unitroots'
                test = @(x) abs(abs(x) - 1) <= realsmall;
        end
        x = nan(size(this.eigval));
        for ialt = 1 : nalt
            index = test(this.eigval(1,:,ialt));
            x(1,1:sum(index),ialt) = this.eigval(1,index,ialt);
        end
        index = all(isnan(x),3);
        x(:,index,:) = [];
    case 'nhyper'
        x = this.nhyper;
    case {'nper','nobs'}
        x = permute(sum(this.fitted,2),[2,3,1]);
    case {'order','p'}
        x = p;
    case {'sample','fitted'}
        x = cell([1,nalt]);
        for ialt = 1 : nalt
            x{ialt} = this.range(this.fitted(1,:,ialt));
        end
    case {'range'}
        x = this.range;
    case 'comment'
        % Not documented. Use comment(this) directly.
        x = comment(this);
    case {'cumlong','cumlongrun'}
        C = sum(poly.var2poly(this.A),3);
        x = nan([ny,ny,nalt]);
        for ialt = 1 : nalt
            if rank(C(:,:,1,ialt)) == ny
                x(:,:,ialt) = inv(C(:,:,1,alt));
            else
                x(:,:,ialt) = pinv(C(:,:,1,ialt));
            end
        end
    case {'constraints','restrictions'}
        x = this.Rr;
    case {'ynames','ylist'}
        x = this.ynames;
    case {'enames','elist'}
        x = this.enames;
    case {'inames','ilist'}
        x = this.inames;
    case {'ieqtn'}
        x = this.ieqtn;
    case {'zi'}
        x = this.Zi;
    case {'names','list'}
        x = [this.ynames,this.enames];
    case 'ny'
        x = size(this.A,1);
    case 'ne'
        x = size(this.Omega,2);
    otherwise
        flag = false;
end

end
