function this = mysubsalt(this,lhs,obj,rhs)
% MYSUBS Implement SUBSREF and SUBSASGN for VAR objects with multiple parameterisations.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if nargin == 2
    
    % Subscripted reference this(lhs).
    this.A = this.A(:,:,lhs);
    this.K = this.K(:,lhs);
    this.Omega = this.Omega(:,:,lhs);
    this.aic = this.aic(1,lhs);
    this.sbc = this.sbc(1,lhs);
    this.eigval = this.eigval(1,:,lhs);
    this.T = this.T(:,:,lhs);
    this.U = this.U(:,:,lhs);
    if ~isempty(this.Sigma)
        this.Sigma = this.Sigma(:,:,lhs);
    end
    this.fitted = this.fitted(1,:,lhs);
    
elseif nargin == 3 && isempty(obj)
    
    % Empty subscripted assignment this(lhs) = [].
    this.A(:,:,lhs) = [];
    this.K(:,lhs) = [];
    this.Omega(:,:,lhs) = [];
    this.aic(:,lhs) = [];
    this.sbc(:,lhs) = [];
    this.eigval(:,:,lhs) = [];
    this.T(:,:,lhs) = [];
    this.U(:,:,lhs) = [];
    if ~isempty(this.Sigma) && ~isempty(x.Sigma)
        this.Sigma(:,:,lhs) = [];
    end
    this.fitted(:,:,lhs) = [];
    
elseif nargin == 4 && strcmp(class(this),class(obj))
    
    % Proper subscripted assignment this(lhs) = obj(rhs).
    try
        this.A(:,:,lhs) = obj.A(:,:,rhs);
        this.K(:,lhs) = obj.K(:,rhs);
        this.Omega(:,:,lhs) = obj.Omega(:,:,rhs);
        this.aic(:,lhs) = obj.aic(:,rhs);
        this.sbc(:,lhs) = obj.sbc(:,rhs);
        this.eigval(:,:,lhs) = obj.eigval(:,:,rhs);
        this.T(:,:,lhs) = obj.T(:,:,rhs);
        this.U(:,:,lhs) = obj.U(:,:,rhs);
        if ~isempty(this.Sigma) && ~isempty(obj.Sigma)
            this.Sigma(:,:,lhs) = obj.Sigma(:,:,rhs);
        end
        this.fitted(:,:,lhs) = obj.fitted(:,:,rhs);
    catch %#ok<CTCH>
        utils.error('VAR', ...
            'Cannot concatenate incompatible VAR objects.');
    end
    
else
    utils.error('VAR', ...
        'Invalid assignment to a VAR object.');
end

end