function flag = isstationary(w,varargin)
% isstationary  True if all eigenvalues are within unit circle.
%
% Syntax
% =======
%
%     flag = isstationary(v)
%
% Input arguments
% ================
%
% * `v` [ VAR ] - VAR object.
%
% Output arguments
% =================
%
% * `flag` [ `true` | `false` ] - True if all eigenvalues are within unit
% circle.
%
% Options
% ========
%
% * `'tolerance='` [ numeric | *getrealsmall()* ] - Tolerance for the
% eigenvalue test.


% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

default = {...
  'tolerance',getrealsmall(),@isnumericscalar, ...
};
options = passvalopt(default,varargin{:});

%**************************************************************************

flag = all(abs(w.eigval) <= 1-options.tolerance,2);
flag = flag(:).';

end
