function flag = isexplosive(this,varargin)
% isexplosive  True if any eigenvalue is outside unit circle.
%
% Syntax
% =======
%
%     FLAG = isexplosive(V)
%
% Input arguments
% ================
%
% * `V` [ VAR ] - VAR object.
%
% Output arguments
% =================
%
% * `FLAG` [ `true` | `false` ] - True if any eigenvalue is outside unit
% circle.
%
% Options
% ========
%
% * `'tolerance='` [ numeric | *getrealsmall()* ] - Tolerance for the
% eigenvalue test.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

default = {...
  'tolerance',getrealsmall(),@isnumericscalar, ...
};
options = passvalopt(default,varargin{:});

%**************************************************************************

flag = any(abs(this.eigval) > 1+options.tolerance,2);
flag = flag(:)';

end
