function v = horzcat(v,varargin)
% horzcat  Combine two compatible VAR objects in one object with multiple parameterisations.
%
% Syntax
% =======
%
%     v = [v1,v2,...]
%
% Input arguments
% ================
%
% * `v1`, `v2` [ VAR ] - Compatible VAR objects that will be combined.
%
% Output arguments
% =================
%
% * `v` [ VAR ] - Output VAR object that combines the input VAR
% objects as multiple parameterisations.
%
% Description
% ============
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

P = inputParser();
P.addRequired('v1',@(x) isa(x,'VAR'));
P.addRequired('v2',@(x) all(cellfun(@(y) isa(y,'VAR'),x)));
P.parse(v,varargin);

%**************************************************************************

if nargin == 1
   return
end

s = struct();
for i = 1 : numel(varargin)
   index = size(v.A,3) + (1 : size(varargin{1}.A,3)); 
   s.type = '()';
   s.subs = {index};
   v = subsasgn(v,s,varargin{1});
end

end