function [A,B,K] = companion(this,varargin)
% companion  Matrices of first-order companion VAR.
%
% Syntax
% =======
%
%     [A,B,K] = companion(v)
%
% Input arguments
% ================
%
% * `v` [ VAR ] - VAR object for which the companion
% matrices will be returned.
%
% Output arguments
% =================
%
% * `A` [ numeric ] - First-order companion transition matrix.
%
% * `B` [ numeric ] - First-order companion coefficient matrix at
% reduced-form residuals.
%
% * `K` [ numeric ] - First-order compnaion constant vector.
%
% Description
% ============
%
% Example
% ========
%}


% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

[ny,p,nalt] = sizeof(this);

%**************************************************************************

if p == 0
   A = zeros([ny,ny,nalt]);
else
   A = zeros([ny*p,ny*p,nalt]);
   for i = 1 : nalt
      A(:,:,i) = [this.A(:,:,i);eye([ny*(p-1),ny*p])];
   end
end

if nargout > 1
   B = eye(ny);
   B = B(:,:,ones([1,nalt]));
   B = [B;zeros([ny*(p-1),ny,nalt])];
   if nargout > 2
      K = [this.K;zeros([ny*(p-1),nalt])];
   end
end

end
