function [THIS,DATA,B,COUNT] = SVAR(V,DATA,varargin)
% SVAR  [Not a public function] Identify SVAR from a reduced-form VAR.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if nargin == 1
    DATA = [];
end

% Parse required input arguments.
P = inputParser();
P.addRequired('V',@(x) isa(x,'VAR'));
P.addRequired('DATA',@(x) isempty(x) || isnumeric(x) || istseries(x) || isstruct(x));
P.parse(V,DATA);

% Parse options.
opt = passvalopt('SVAR.SVAR',varargin{1:end});

%**************************************************************************

[ny,p,nalt] = sizeof(V); %#ok<ASGLU>

% Create an empty SVAR object.
THIS = SVAR();
THIS.B = nan(ny,ny,nalt);
THIS.std = nan(1,nalt);

% Populate the superclass VAR properties.
list = utils.ndprop('VAR');
for i = 1 : length(list)
   THIS.(list{i}) = V.(list{i});
end

% Identify the B matrix.
[THIS,DATA,B,COUNT] = myidentify(THIS,DATA,opt);

end
