function [c,d] = fprintf(this,fname,varargin)
% fprintf  Format SVAR as a model code and write to text file.
%
% Syntax
% =======
%
%     [c,d] = fprintf(s,fname,...)
%
% Input arguments
% ================
%
% * `s` [ SVAR ] - SVAR object that will be written as a model code.
%
% * `fname` [ char | cellstr ] - Filename, or filename format string, under
% which the model code will be saved.
%
% - Output arguments
%
% * `c` [ cellstr ] - Text string with the model code for each
% parameterisation.
%
% * `d` [ cell ] - Parameter databases for each parameterisation; if
% `'hardParameters='` true, the database will be empty.
%
% Options
% ========
%
% See help on [`sprintf`](SVAR/sprintf) for options available.
%
% Description
% ============
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.
    
    IP = inputParser();
    IP.addRequired('v',@issvar);
    IP.addRequired('fname',@(x) ischar(x) ...
        || (iscellstr(x) && length(this) ==  numel(x)));
    IP.parse(this,fname);
    
%**************************************************************************
    
    [c,d] = sprintf(this,varargin{:});
    for ialt = 1 : length(c)
        if iscellstr(fname)
            thisfname = fname{ialt};
        else
            thisfname = sprintf(fname,ialt);
        end
        char2file(c{ialt},thisfname);
    end
    
end