function [x,flag] = specget(this,query)
% specget  Implement GET method for FAVAR objects.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

x = [];
flag = true;

ny = size(this.C,1);
nx = size(this.C,2);
p = size(this.A,2)/nx;
nalt = size(this.C,3);

switch query
   case {'ynames','ylist','names','list'}
      if isfunc(this.ynames)
         x = cell([1,ny]);
         for i = 1 : ny
            x{i} = this.ynames(i);
         end
      else
         x = this.ynames;
      end
   case 'a'
      if all(size(this.A) == 0)
         x = [];
      else
         x = poly.var2poly(this.A);
      end
   case 'a*'
      x = reshape(this.A,[nx,nx,p,nalt]);
   case 'b'
      x = this.B;
   case 'c'
      x = this.C;
   case 'omega'
      x = this.Omega;
   case 'sigma'
      x = this.Sigma;
   case 'var'
      x = VAR(this);
   case {'eig','eigval'}
      x = this.eigval;
   case {'singval','sing','singvalues'}
      x = this.singval;
   case {'ny'}
      x = size(this.C,1);
   case {'nx'}
      x = size(this.A,1);
   case {'ne'}
      x = size(this.Omega,2);
   case 'nu'
      x = size(this.Sigma,2);
   case 'mean'
      x = this.Mean;
   case 'std'
      x = this.Std;
   otherwise
      flag = false;
end

end