function s = sgf(a,freq)

freq = freq(:).';
nfreq = length(freq);
n = length(a.ar);
s = nan(1,1,nfreq);
for i = 1 : numel(freq)
    lmb = freq(i);
    s(1,1,i) = 0;
    for j = 1 : n
        L = exp(-1i*lmb);
        F = exp(1i*lmb);
        ar = a.ar{j}(end:-1:1);
        ma = a.ma{j}(end:-1:1);
        s(1,1,i) = s(1,1,i) ...
            + polyval(ma,L)*polyval(ma,F) ...
            / (polyval(ar,L)*polyval(ar,F));
    end
end

end