function warning(mnemo,body,varargin)
% warning  [Not a public function] IRIS warning master file.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

try %#ok<TRYNC>
    q = warning('query',['iris:',mnemo]);
    if strcmp(q.state,'off')
        return
    end
end

if ~isempty(body) && body(1) == '#'
    body = frequents(mnemo,body);
end

stack = dbstack('-completenames');
% Get the IRIS root directory name.
[ans,irisfolder] = fileparts(irisget('irisroot')); %#ok<NOANS,ASGLU>
% Exclude functions contained in the IRIS root directory.
omit = 0;
nstack = length(stack);
while omit < nstack ...
        && ~isempty(strfind(stack(omit+1).file,irisfolder))
    omit = omit + 1;
end
msg = sprintf('<a href="">IRIS Toolbox Warning</a> :: %s.', ...
    (mnemo));
if isempty(varargin)
    msg = [msg,sprintf('\n*** '),body];
else
    msg = [msg,sprintf(['\n*** ',body],varargin{:})];
end
state = warning('off','backtrace');
warning(['IRIS:',mnemo],'%s',msg);
warning(state);
strfun.loosespace();

end

% Subfunctions.

%**************************************************************************
function body = frequents(mnemo,body) %#ok<INUSL>

switch body
    case '#Solution_not_available'
        body = 'Solution not available in%s.';
    otherwise
        body = '';
end

end
% frequents().