function [Z,C] = lincomb2vector(S,LIST)

if ~iscell(S)
    S = {S};
end
S = S(:).';

ns = length(S);
nlist = length(LIST);

LIST = regexptranslate('escape',LIST);
for i = 1 : nlist
    S = regexprep(S,['\<',LIST{i},'\>'],sprintf('x(%g)',i));
end

Z = zeros(ns,nlist);
C = zeros(ns,1);;
for i = 1 : ns
    [Z(i,:),C(i)] = xxlincomb2vector(S{i},nlist);
end

end

% Subfuntions.

%**************************************************************************
function [Z,C] = xxlincomb2vector(S,nlist)

f = str2func(['@(x)',S]);
x = zeros(1,nlist);
try
    C = f(x);
catch %#ok<CTCH>
    C = NaN;
end
Z = nan(1,nlist);

for i = 1 : nlist
    x = zeros(1,nlist);
    x(i) = 1;
    Z(i) = f(x) - C;
end

end
% xxlincomb2vector().