function error(mnemonic,body,varargin)

if ~isempty(body) && body(1) == '#'
    body = frequents(mnemonic,body);
end

stack = dbstack('-completenames');
% Get the IRIS root directory name.
[ans,irisfolder] = fileparts(irisget('irisroot')); %#ok<NOANS,ASGLU>
% Exclude functions contained in the IRIS root directory.
omit = 0;
nstack = length(stack);
while omit < nstack ...
        && ~isempty(strfind(stack(omit+1).file,irisfolder))
    omit = omit + 1;
end
stack(1:omit-1) = [];
% Throw an error with stack of non-iris function calls.
if isempty(stack)
    stack = struct('file','','name','','line',NaN);
end
msg = sprintf('IRIS Toolbox Error :: %s.',(mnemonic));
if isempty(varargin)
    msg = [msg,sprintf('\n*** '),body];
else
    msg = [msg,sprintf(['\n*** ',body],varargin{:})];
end
tmp = struct();
tmp.message = msg;
tmp.identifier = ['IRIS:',mnemonic];
tmp.stack = stack;
error(tmp);

end

% Subfunctions.

%**************************************************************************
function body = frequents(mnemonic,body) %#ok<INUSL>

switch body
    case '#Name_not_exists'
        body = 'This name does not exist in the model object: %s.';
    otherwise
        body = '';
end

end
% frequents().