function Phi = var2vma(A,B,nper,select)
% var2vma  VMA representation of a VAR process.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[ny,p,nalt] = size(A);
p = p/ny;

if ~exist('select','var')
    select = true(1,ny);
end
ne = sum(select); 

A = reshape(A,ny,ny,p,nalt);

Phi = zeros(ny,ne,nper,nalt);
for ialt = 1 : nalt
    if isempty(B)
        Phi0 = eye(ny);
    else
        Phi0 = B(:,:,ialt);
    end
    Phi(:,:,1,ialt) = Phi0(:,select);
    for t = 2 : nper
        for k = 1 : min(p,t-1)
            Phi(:,:,t,ialt) = ...
                Phi(:,:,t,ialt) + A(:,:,k,ialt)*Phi(:,:,t-k,ialt);
        end
    end
end

end
